/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
/**
 *  This sample add a picture to the Page Header section of a report at runtime
 */

package rdc;

import com.inet.report.Engine;

/**
 * This sample shows how you can add a picture to a section of the report using RDC API.
 */
public class AddPictureToReport extends RDCSample {

    // Change the URL of the rpt file before running this example if the default location of the file "mainrep.rpt"
    // was changed. The default directory of this rpt file is: "samples/rdc".
    static private final String MAINREPORT = "samples/rdc/mainrep.rpt";

    /**
     * Creates a new engine, set the report file and add a picture to the section Page Header
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        try {
            // Create a new Engine
            Engine eng = new Engine( exportFmt );
            // Set the report file
            eng.setReportFile( MAINREPORT );

            // Add a picture to the Page Header section
            eng.getArea( "PH" ).getSection( 0 ).addPicture( 8100, 100, 2835, 375, "samples/rdc/cc_logo.png" );
            return eng;
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param argv arguments not used
     */
    public static void main( String[] argv ) {
        new AddPictureToReport().initUI();
    }
}
